<?php

namespace App\Http\Requests\Admin\Refund;

use App\Models\Order;
use App\Models\Refund;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;


class StoreRefundRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'refund_amount' => ['required', 'numeric', 'gt:0', function($attribute, $value, $fail) {
            $order = Order::find($this->route('id'));
            if ($order) {
                $maxAmount = $order?->order_amount + $order?->total_tax - ($order?->coupon_discount_amount ?? 0) - ($order?->extra_discount ?? 0);
                if ($value > $maxAmount) {
                    $fail('Refund amount can not be greater than total amount');
                }
            }
            }],
            'refund_reason' => 'nullable|string|max:255',
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
           $orderId = $this->route('id');

           if (!Order::where('id', $orderId)->exists()) {
               $validator->errors()->add('order_id', 'Order not found');
           }

           if (Refund::where('order_id', $orderId)->exists()) {
               $validator->errors()->add('order_id', 'Refund already exists for this order');
           }
        });
    }
}
