@push('css_or_js')
<link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/custom.css"/>
@endpush
<ul class="list-group list-group-flush product-search-list" id="productList">
    @forelse($products as $product)
        <li class="list-group-item">
            <a href="#" data-product-id="{{ $product->id }}" class="add-to-cart-link">
                <div>
                    <img src="{{$product['image_fullpath']}}" class="rounded" width="48">
                </div>
                <div class="w-0 flex-grow-1">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6>{{ $product['name'] }}</h6>
                            <small><del>{{ $product['selling_price'] . ' ' . \App\CPU\Helpers::currency_symbol() }}</del></small>
                            <span>{{ ($product['selling_price']- \App\CPU\Helpers::discount_calculate($product, $product['selling_price'])) . ' ' . \App\CPU\Helpers::currency_symbol() }}</span>
                        </div>
                        <div class="fz-12">
                            <div class="mb-2">{{ \App\CPU\translate('Sku no') }}: {{ $product['product_code'] }}</div>
                            <div>{{ \App\CPU\translate('Stock') }}: <span class="text-success">{{ $product['quantity'] }}</span> </div>
                        </div>
                    </div>
                </div>
            </a>
        </li>
    @empty
        <div class="bg-soft-secondary p-3 rounded text-center">
            <img src="{{ asset('public/assets/admin/img/no-product.png') }}" alt="img">
            <p>{{ \App\CPU\translate('No Product Found ') }}</p>
        </div>
    @endforelse
</ul>

<script>
    "use strict";

    $('#productList').on('click', '.add-to-cart-link', function(e) {
        e.preventDefault();
        var productName = $(this).text();
        $('.search-bar-input-mobile').val(productName);
        $('.search-bar-input').val(productName);
        var productId = $(this).data('product-id');
        addToCart(productId);
    });
</script>
